/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth.util;

import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.ui.UIObjectProperties;
import com.ibm.hwmca.fw.ui.UIObjectsReader;
import com.ibm.hwmca.fw.ui.UIObjectsWriter;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.ShortObjectIdManager;
import com.ibm.hwmca.ui.bonsai.config.BonsaiConfigException;
import com.ibm.hwmca.ui.bonsai.earth.Targetable;
import com.ibm.hwmca.ui.bonsai.earth.TaskContainerNode;
import com.ibm.hwmca.ui.bonsai.earth.TaskNode;
import com.ibm.hwmca.ui.bonsai.earth.util.MOTreeTaskRetriever;
import com.ibm.hwmca.ui.bonsai.servlet.ControllerServlet;
import com.ibm.hwmca.ui.bonsai.servlet.util.TaskUrl;
import com.ibm.hwmca.ui.bonsai.servlet.util.UISession;
import com.ibm.hwmca.ui.bonsai.util.SortedList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class MOStatusTreeTaskRetriever
extends MOTreeTaskRetriever {
    private static final String STATUS_GROUP_ID = "status.taskgroup.id";
    private static final String BUNDLE = "com/ibm/hwmca/ui/bonsai/res/text";
    private static final String STATUS_GROUP_NAME_KEY = "taskgroup.status.name";
    private static final String STATUS_GROUP_CAPTION_KEY = "taskgroup.status.caption";
    private TaskNode statusTaskGroup;

    public void init(String key, Map params) throws BonsaiConfigException {
        super.init(key, params);
        String keysParam = (String)params.get("keys");
        if (keysParam == null) {
            throw new BonsaiConfigException("No task keys were specified in the XML!");
        }
        this.statusTaskGroup = new TaskNode(STATUS_GROUP_ID, new UIInfo(new LocalizableText(BUNDLE, STATUS_GROUP_NAME_KEY), new LocalizableText(BUNDLE, STATUS_GROUP_CAPTION_KEY)), false);
        UIObjectsReader reader = ControllerServlet.getUIObjectsReader();
        ShortObjectIdManager idManager = UIObjectsWriter.getUIObjectsWriter().getShortObjectIdManager();
        ObjectId objId = new ObjectId("com.ibm.hwmca.fw.managed.Task");
        String taskId = null;
        byte[] buffer = null;
        StringTokenizer tokens = new StringTokenizer(keysParam, ";");
        while (tokens.hasMoreTokens()) {
            objId.setKeyProperty("Name", tokens.nextToken());
            taskId = idManager.getShortId(objId);
            if (taskId == null) continue;
            buffer = reader.getBuffer(taskId);
            this.statusTaskGroup.addChild(new TaskNode(taskId, new UIInfo(UIObjectProperties.getName(buffer), UIObjectProperties.getCaption(buffer), UIObjectProperties.getImageName(buffer)), true, new TaskUrl(taskId, 2)));
        }
    }

    public List getTasks(TaskContainerNode node, UISession session) {
        Set targetableTasks = session.getUIObjectsReader().getAllowedTasks(((Targetable)((Object)node)).getShortId());
        TaskNode group = this.statusTaskGroup.getNoChildrenClone();
        TaskNode task = null;
        Iterator i = this.statusTaskGroup.getChildren().iterator();
        while (i.hasNext()) {
            task = (TaskNode)i.next();
            if (!targetableTasks.contains(task.getId())) continue;
            group.addChild(task);
        }
        if (group.getChildren().isEmpty()) {
            return super.getTasks(node, session);
        }
        SortedList taskTrees = new SortedList(TaskNode.getTaskNodeComparator());
        taskTrees.add(group);
        taskTrees.addAll(super.getTasks(node, session));
        return taskTrees;
    }
}

